package gov.va.med.domain.model;

import gov.va.med.framework.bean.AbstractVO;

import java.io.Serializable;
import java.util.Date;

public class RxRefillPayload extends AbstractVO implements IPayload, Serializable {
	private Long requestId;
	private Long requestAttemptId;
	private Patient patient;
	private Prescription[] prescriptionList;
	private Date fromDate = null;
	private Date toDate = null;
	private Institution institution = null ;
	public RxRefillPayload() {
	}
	public RxRefillPayload(Long requestId, Long requestAttemptId, Patient patient, Institution institution) {
		this.requestId = requestId;
		this.requestAttemptId = requestAttemptId;
		this.patient = patient;
		this.institution = institution;
	}
	public RxRefillPayload(Long requestId,Patient patient, Institution institution) {
		this.requestId = requestId;
		
		this.patient = patient;
		this.institution = institution;
	}
	public RxRefillPayload(Long requestId, Long requestAttemptId,Patient patient, Institution institution, Date fromDate, Date toDate) {
		this(requestId, requestAttemptId,patient, institution);
		this.fromDate = fromDate;
		this.toDate = toDate;
	}

	
	public RxRefillPayload(Long requestId,
            Patient patient,
            Institution institution,
            Prescription[] prescriptionList
            ) {
		this(requestId, patient, institution);
		this.prescriptionList = prescriptionList;
		
	}

	public Long getRequestId() {return requestId;}
	public Long getRequestAttemptId() {return requestAttemptId;}

	public Patient getPatient() {return patient;}

	public Prescription[] getPrescriptionList() {return prescriptionList;}

	public Date getFromDate() {return fromDate;}

	public Date getToDate() {return toDate;}

	public Institution getInstitution() {return institution;}

	public void setRequestId(Long requestId) {this.requestId = requestId;}
	public void setRequestAttemptId(Long requestAttemptId) {this.requestAttemptId = requestAttemptId;}
	public void setPatient(Patient patient) {this.patient = patient;}

	public void setPrescriptionList(Prescription[] prescriptionList) {this.prescriptionList = prescriptionList;}

	public void setFromDate(Date fromDate) {this.fromDate = fromDate;}

	public void setToDate(Date toDate) {this.toDate = toDate;}

}


    
    
